{ Invokable implementation File for TFuncionarios which implements IFuncionarios }

unit FuncionariosImpl;

interface

uses InvokeRegistry, Types, XSBuiltIns, FuncionariosIntf;

type

  { TFuncionarios }
  TFuncionarios = class(TInvokableClass, IFuncionarios)
  public
    procedure ReajusteSalarial; stdcall;
    function NFunc(ACountry: string):Integer; stdcall;
  end;

implementation

uses SysUtils, SQLExpr, DataFuncionarios, DBXpress;

var
  TD: TTransactionDesc;

{ TFuncionarios }

function TFuncionarios.NFunc(ACountry: string):Integer;
begin
 with dmDataFuncionarios.qrFunc do
  begin
    try

      try
        Sql.Clear;
        Sql.Add('select count(*) from employee where job_country = :job');
        ParamByName('job').AsString := ACountry;
        Open;
        Result := Fields[0].AsInteger
      except
        Result := 0;
      end;

    finally
      Close;
    end;
  end;
end;

procedure TFuncionarios.ReajusteSalarial;
begin
  with dmDataFuncionarios, qrFunc do
  begin
   try

     try
      SQL.Clear;
      SQL.Add('select e.emp_no, count(proj_id) from employee e');
      SQL.Add('inner join employee_project p on (e.emp_no = p.emp_no)');
      SQL.Add('group by e.emp_no');
      Open;
      First;

      TD.TransactionID := 1;
      TD.IsolationLevel := xilREADCOMMITTED;

      if not SQLConnection.InTransaction then
        SQLConnection.StartTransaction(TD);

      while not Eof do
      begin

        case Fields[1].AsInteger of
          1: begin
               sqlUpdate.CommandText := 'update employee set salary =  salary + (salary * 5.0 / 100)' +
                 ' where emp_no = ' + Fields[0].AsString;
               sqlUpdate.ExecSQL;
             end;

          2: begin
               sqlUpdate.CommandText := 'update employee set salary =  salary + (salary * 10.0 / 100)' +
                ' where emp_no = ' + Fields[0].AsString;
               sqlUpdate.ExecSQL;
             end;

          3..5: begin
                  sqlUpdate.CommandText := 'update employee set salary =  salary + (salary * 15.0 / 100)' +
                   ' where emp_no = ' + Fields[0].AsString;
                  sqlUpdate.ExecSQL;
                end;
        else
          sqlUpdate.CommandText := 'update employee set salary =  salary + (salary * 20.0 / 100)' +
           ' where emp_no = ' + Fields[0].AsString;
          sqlUpdate.ExecSQL;
        end;

        Next;
      end;

      SQLConnection.Commit(TD);

     except
       on E:Exception do
       begin
         SQLConnection.Rollback(TD);
         raise Exception.Create(E.Message);
       end;
     end;

   finally
     Close;
   end;
 end;
end;

initialization
  { Invokable classes must be registered }
  InvRegistry.RegisterInvokableClass(TFuncionarios);
end.
 